// By EVOLVED
// www.evolved-software.com

#define Specularity 1

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 View:View;
   float4x4 Project:Projection;
   float4x4 ViewProj:ViewProjection; 
   float4x4 ViewInv:ViewInverse;

//--------------
// tweaks
//--------------
   float4 ViewSize1;
   float4 ViewSize2;
   float2 CamRange;
   float4 FogColor;
   float4 AmbientColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float TileRange;
   float4x4 ShadowsProj;
   float3 ShadowsPosition;
   float3 ShadowsDirection;
   float ShadowsRange;
   float3 ShadowsSize;
   float Normalz=0.75;

//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;	
   sampler BaseSampler=sampler_state 
      {
 	Texture=<BaseTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=8;
      };
   texture NormalMapTexture <string Name = "";>;	
   sampler NormalMapSampler=sampler_state 
      {
 	Texture=<NormalMapTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=4;
      };
   texture SecondarysTexture <string Name = "";>;	
   sampler SecondarysSampler=sampler_state 
      {
 	Texture=<SecondarysTexture>;
      };
   texture ReflectionTexture <string Name="";>;
   sampler ReflectionSampler=sampler_state
      {
	Texture=<ReflectionTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
	AddressW=Clamp;
      };
   texture DepthTexture <string Name = "";>;	
   sampler DepthSampler=sampler_state 
      {
 	Texture=<DepthTexture>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture MaskTexture <string Name = "";>;	
   sampler MaskSampler=sampler_state 
      {
 	Texture=<MaskTexture>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture ShadowMapTexture <string Name = "";>;	
   sampler ShadowMapSampler=sampler_state 
      {
 	Texture=<ShadowMapTexture>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture LightDataTexture <string Name = "";>;	
   sampler LightDataSampler=sampler_state 
      {
 	Texture=<LightDataTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };

//--------------
// structs 
//--------------
   struct Input
     {
 	float4 Pos:POSITION;
    	float2 UV:TEXCOORD; 
 	float3 Normal:NORMAL;
 	float3 Tangent:TANGENT;
     };
   struct Output
     {
 	float4 Pos:POSITION;
	float2 Tex:TEXCOORD0;
	float4 Proj:TEXCOORD1;
  	float3 TBNRow1:TEXCOORD2; 
  	float3 TBNRow2:TEXCOORD3; 
  	float3 TBNRow3:TEXCOORD4;
 	float4 WorldPos:TEXCOORD5;
 	float3 ViewVec:TEXCOORD6;
	float Shadows:COLOR0;
     };

//--------------
// vertex shader
//--------------
   Output VS(Input IN) 
    {
 	Output OUT;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Pos=mul(float4(WorldPos,1),ViewProj);
 	OUT.Tex=IN.UV;
	Project[2].z=-1.0/(CamRange.y-CamRange.x), Project[3].z=(CamRange.y-CamRange.x)/CamRange.y;
	float4 PosLinear=mul(mul(float4(WorldPos,1),View),Project); 
        OUT.Proj=float4(PosLinear.x*0.5+0.5*PosLinear.w,0.5*PosLinear.w-PosLinear.y*0.5,PosLinear.z,PosLinear.w);
	float3 Normals=normalize(mul(IN.Normal,World)); 
	float3 Tangent=normalize(mul(IN.Tangent,World));
	OUT.TBNRow1=Tangent;
	OUT.TBNRow2=cross(Normals,Tangent);
	OUT.TBNRow3=Normals;
	OUT.WorldPos=float4(WorldPos,0); 
	OUT.ViewVec=ViewInv[3].xyz-WorldPos;
    	float4 LightProj=mul(float4(WorldPos,1),ShadowsProj)*float4(0.5,-0.5,0,0)+0.5;
	float ShadowDepth=dot(WorldPos-ShadowsPosition,ShadowsDirection)/ShadowsRange;
	float4 ShadowMap=float4(tex2Dlod(ShadowMapSampler,LightProj).x,tex2Dlod(ShadowMapSampler,LightProj+ShadowsSize.yzzz).x,
			        tex2Dlod(ShadowMapSampler,LightProj+ShadowsSize.zyzz).x,tex2Dlod(ShadowMapSampler,LightProj+ShadowsSize.yyzz).x);
	ShadowMap=step(ShadowDepth,ShadowMap);
	ShadowMap.xy=lerp(ShadowMap.xz,ShadowMap.yw,frac(ShadowsSize.x*LightProj.x));
	OUT.Shadows=lerp(ShadowMap.x,ShadowMap.y,frac(ShadowsSize.x*LightProj.y));
	return OUT;
    }

//--------------
// pixel shader
//--------------
    float4 PS_Lighting(Output IN)  : COLOR
     {
	float2 dx=ddx(IN.Tex), dy=ddy(IN.Tex);
	float4 Proj=((IN.Proj/IN.Proj.w)*ViewSize2)+ViewSize1;
	if(Proj.z-tex2Dlod(DepthSampler,Proj).x<Proj.z*0.002) discard;
	float4 Diffuse=pow(tex2Dgrad(BaseSampler,IN.Tex,dx,dy),float4(2.2,2.2,2.2,1));
	float4 NormalMap=tex2Dgrad(NormalMapSampler,IN.Tex,dx,dy);
	float4 Secondarys=tex2Dgrad(SecondarysSampler,IN.Tex,dx,dy);
	float ViewDist=length(IN.ViewVec);
	float3 ViewVec=normalize(IN.ViewVec);
	float3x3 WorldTBN=float3x3(IN.TBNRow1,IN.TBNRow2,IN.TBNRow3);
	float3 Normals=normalize(mul(float3(NormalMap.yw*2-1,Normalz),WorldTBN));
	float ViewNormal=max(dot(ViewVec,Normals),0);
	float3 Specular=lerp(0.04,Diffuse.xyz,NormalMap.x);
	Specular +=(1-Specular)*(1-NormalMap.z)*pow(1-ViewNormal,5);
	float3 Lighting=LightDirectionColor*max(dot(LightDirection,Normals),0)*IN.Shadows;
	#if Specularity == 1
	 float Distribution=pow(NormalMap.z*NormalMap.z+0.004,2.2);
	 float Denominator=Distribution.x-1;
	 float HalfVec=max(dot(normalize(LightDirection+ViewVec),Normals),0)*Denominator+1.0001;
	 float3 LightSpecular=(Distribution/(3.141592*HalfVec*HalfVec))*Lighting;
	#else
	 float3 LightSpecular=0;
	#endif
	float4 TileProj=IN.Proj/IN.Proj.w;
        float4 TileCount=tex2Dlod(LightDataSampler,TileProj*0.03125);
	float TileArray=(floor(TileProj.x*8)+floor(TileProj.y*8)*8)*0.00390625;
	int TileDepth=clamp(floor(ViewDist/TileRange),0,3);
        for(int i=0; i<int(TileCount[TileDepth]); i++ ) {
	  float4 LightArray=tex2Dlod(LightDataSampler,float4((i+128.0)*0.00390625,TileArray,0,0));
	  LightArray.xy=float2(LightArray[TileDepth]*0.00390625,0.98828125);
	  float4 LightColor=tex2Dlod(LightDataSampler,LightArray);
      	  float4 LightVec=tex2Dlod(LightDataSampler,LightArray+float4(0,0.00390625,0,0))-IN.WorldPos;
	  float4 LightSpot=tex2Dlod(LightDataSampler,LightArray+float4(0,0.0078125,0,0));
	  float Attenuation=length(LightVec.xyz);
	  LightVec.xyz /=Attenuation;
  	  LightColor.xyz *=saturate((dot(LightVec.xyz,LightSpot.xyz)-LightSpot.w)/frac(LightColor.w));
	  LightColor.xyz *=max(dot(LightVec.xyz,Normals),0)*max(1/(Attenuation/LightVec.w)-1,0);
	  Lighting +=LightColor.xyz;
	  #if Specularity == 1
	   float HalfVec=max(dot(normalize(LightVec.xyz+ViewVec),Normals),0)*Denominator+1.0001;
	   LightSpecular +=(Distribution/(3.141592*HalfVec*HalfVec))*LightColor.xyz;
	  #endif
	}
	float Alpha=saturate(Diffuse.w+dot(LightSpecular,0.01)+pow(1-ViewNormal,5)*NormalMap.z);
	float3 ViewReflection=reflect(ViewVec,Normals);
	float2 Equirectangular=0.3183*float2(atan2(-ViewReflection.z,ViewReflection.x),acos(ViewReflection.y));
	float4 Reflection=tex2Dlod(ReflectionSampler,float4(Equirectangular.x*0.5+0.5,1-Equirectangular.y,0,0));
	LightSpecular +=Reflection.xyz*pow(1.04,Reflection.w*255.0-128.0)*AmbientColor.w;
	Lighting +=AmbientColor.xyz*Secondarys.y;
	Lighting *=(1-Specular)*(1-NormalMap.x)*Diffuse.xyz;
	Lighting +=(LightSpecular*Specular)+(Diffuse.xyz*Secondarys.x*25);
	float FogDist=1-saturate(1-exp(-(ViewDist/FogColor.w)));
	return float4(Lighting,Alpha*FogDist);
     }
    float4 PS_Distortion(Output IN)  : COLOR
     {
	float2 dx=ddx(IN.Tex), dy=ddy(IN.Tex);
	float4 Proj=((IN.Proj/IN.Proj.w)*ViewSize2)+ViewSize1;
	if(Proj.z-tex2Dlod(DepthSampler,Proj).x<Proj.z*0.002) discard;
	float4 Diffuse=pow(tex2Dgrad(BaseSampler,IN.Tex,dx,dy),float4(2.2,2.2,2.2,1));
	float4 NormalMap=tex2Dgrad(NormalMapSampler,IN.Tex,dx,dy);
	float4 Secondarys=tex2Dgrad(SecondarysSampler,IN.Tex,dx,dy);
	float ViewDist=length(IN.ViewVec);
	float3 ViewVec=normalize(IN.ViewVec);
	float3x3 WorldTBN=float3x3(IN.TBNRow1,IN.TBNRow2,IN.TBNRow3);
	float3 Normals=normalize(mul(float3(NormalMap.yw*2-1,Normalz),WorldTBN));
	float ViewNormal=max(dot(ViewVec,Normals),0);
	float3 Distort=normalize(mul(Normals,ViewProj).xyz)*(1-ViewNormal)*Secondarys.z;
	return float4(0.5+float2(-Distort.x,Distort.y)*0.5,1,Diffuse.w+pow(1-ViewNormal,5)*Secondarys.y);
     }

//--------------
// techniques   
//--------------
    technique Lighting
      {
 	pass p1
      {
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS_Lighting();
        ColorWriteEnable=7;
      }
      }
    technique Distortion
      {
 	pass p1
      {
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS_Distortion();
        ColorWriteEnable=7;
      }
      }
